% SCRIPT for the initialisation
% of the magnetic lavitation system
% parameters

m  = 0.0300;
mpert = 0;
R  = 45;
L1 = 0.6000;
C  = 6.3000e-04;

g = 9.80;

% INITIAL CONDITIONS:
x1_0 = 0.1;
x2_0 = 0;
x3_0 = 0.2;

%SET-POINT:
x1_d = 0.05;
x2_d = 0;
x3_d = sqrt(g*m/C)*x1_d;

% desired condition: x = [x1_d x2_d x3_d] 
% u_d = x3_d*R

K = 1.0e+03 * [-2.4567   -0.1235    0.0237];

Ts = 0.005; % sampling time