%%%
%%% File for the design of the output observers
%%% for sensors fault diagnosis
%%%

Am = 1.0e+03 * [0         0         0.0010
                4.0945   -0.1145    0.2067
                0.3920   -0.0181         0];
            
            
Bm = 1.0e+03 * [0
                -1.6210
                0];
            

Cm = [1     0     0
      0     1     0];
  
  
Dm = [0
      0];
 

  
%%% 1st observer for y_1  
  
v = [-81 -82 -83]; % observer eigenvalues: 
                   % if too negative, they 
                   % amplify the noised
H1  = place(Am',Cm(1,:)',v)'; % 1st observer
                              % gain
Ao1 = Am - H1*Cm(1,:);
Bo1 = [Bm H1];
Co1 = Cm(1,:);
Do1 = zeros(1,2);

%%% Design of the 2nd observer for y_2 

H2  = place(Am',Cm(2,:)',v)'; % 2nd observer 
                              % gain
Ao2 = Am - H2*Cm(2,:);
Bo2 = [Bm H2];
Co2 = Cm(2,:);
Do2 = zeros(1,2);

return