%%%
%%% Esempio di progetto dell'osservatore d'uscita
%%% per un modello SISO a tempo discreto
%%%

% Progetto dell'osservatore per il sistema nello spazio
% degli stati:

% x(t+1) = A x(t) + B u(t)
% y(t)   = C x(t) + D u(t)

%
% Equazione dell'osservatore d'uscita
%

% x^(t+1) = A x^(t) + B u(t) + K [ y(t) - C x^(t) ]
% y^(t)   = C x^(t)

% Riscrivo l'equazione dell'osservatore nella
% forma di modello nello spazio degli stati:

% x^(t+1) = (A - KC) x^(t) + [B K] [u(t) y(t)]' 
% y^(t)   = C x^(t) + [0 0] [u(t) y(t)]'

% m = numero uscite del sistema;
% r = numero ingressi del sistema;

% Ao = A - KC;
% Bo = [B K];
% Co = C;
% Do = zeros(m,r+m);

% K (guadagno dell'osservatore) tale che
% la matrice Ao = A-KC abbia autovalori stabili
% sono in modulo minori di 1 (autovalori v
% che si vogliono assegnare arbitrariamente

% K = place(A',C',v)';

clear all, close all, clc

%%%
%%% Definizione del modello simulato e
%%% progetto dell'osservatore
%%%

Tc = 0.1; % Tempo di campionamento

A = [0.9944 -0.1203 -0.4302;
     0.0017  0.9902 -0.0747;
     0       0.8187  0];

% n = 3; 
 
B = [0.4252 -0.0082 0.1813]';

C = [1 0 0]; % m = 1; singola uscita

r = 1; % numero delle colonne della matrice B ù
       % (dim. n x r)
m = 1; % numero delle righe della matrice C
       % (dim. m x n)

D = zeros(m,r); % Sistema puramente dinamico       
       
v = [0.1 0.15 0.17]; % autovalori da assegnare

x0 = 0.05; % condizione iniziale

% Matrici del modello dell'osservatore

K = place(A',C',v)'; % guadagno dell'osservatore
                     % Nota: il progetto dell'osservatore
                     % è possibile solo se il sistema
                     % è completamente osservabile!
                     % Verifica: rank(obsv(A,C)) == n
Ao = A - K*C;
Bo = [B K];
Co = C;
Do = zeros(m,r+m);

