%%%
%%% File "train_net.m": training della rete neurale  
%%% per la diagnosi dei guasti
%%%

% Carica Psim e Tsim;

P = Psim(1:round(size(Psim,1)/3),:)';
T = Tsim(1:round(size(Psim,1)/3),1)';

%%%
%%% Parametri per la generazione della rete
%%%

Si = 7;  % Numero di neuroni nello strato di ingresso
Sh = 15; % Numero di neuroni nello strato nascosto
So = 1;  % Numero di neuroni nello strato di uscita

TFi = 'tansig';
TFh = 'tansig';
TFo = 'purelin';

%BTF = 'traingdx'; % Funzione di addestramento rete backpropagation, default
BTF = 'trainlm';   % Levenberg-Marquardt backpropagation 

BLF = 'learngdm'; % Funzione di apprendimento backpropagation weight/bias, default

PF  = 'mse';      % Funzione di performance, default

PR  = minmax(P);  % Equivalente a: [min(P')' , max(P')'], trova i valori 
                      % minimi e massimi degli ingressi

val.P  = Psim(round(size(Psim,1)/3)+1:2*round(size(Psim,1)/3),:)';   % validation data                  
val.T  = Tsim(round(size(Psim,1)/3)+1:2*round(size(Psim,1)/3),:)';
test.P = Psim(2*round(size(Psim,1)/3)+1:end,:)';   % test data  
test.T = Tsim(2*round(size(Psim,1)/3)+1:end,:)';

net = newff(PR,[Si Sh So],{TFi TFh TFo},BTF,BLF,PF);

%%%
%%% Parametri per l'addestramento della rete
%%%

net.trainParam.epochs = 300;    % Numero di epoche
net.trainParam.goal   = 1e-7;   % Valore dell'errore finale
net.trainParam.show   = 1;      % Mostra il grafico dopo ogni tot epoche
net.trainParam.lr     = 0.05;   % Learning rate per trainlm
net.trainParam.mc     = 0.9;

net = train(net,P,T,[],[],val,test);

%Ts = xxx;     % Tempo di campionamento
            % NOTA BENE: accertarsi che il tempo di campionamento
            % dei dati memorizzati in Tsim e Psim corrisponda a questo!


gensim(net,Ts);